package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.biz.RequestAdminParticipantDocument;
import gov.va.vinci.dart.db.RequestAdminParticipantDocumentDAO;

public class RequestAdminParticipantDocumentDAOMock implements RequestAdminParticipantDocumentDAO {
	
	private static HashMap<Integer,RequestAdminParticipantDocument> IDHash = new HashMap<Integer,RequestAdminParticipantDocument>();
	private static boolean initialized = false;
	private static int idCounter = 1;
	
	@Override
	public void save(RequestAdminParticipantDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
	
		initializeDocHash();
		
		if (document.getId() == 0) {
			document.setId(idCounter++);
		}
		
		IDHash.put(document.getId(), document);
	}

	@Override
	public void delete(RequestAdminParticipantDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		initializeDocHash();

		IDHash.remove(document.getId());
	}


	@Override
	public List<RequestAdminParticipantDocument> listByRequestId(int requestId) {
		List<RequestAdminParticipantDocument> result = new ArrayList<RequestAdminParticipantDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestAdminParticipantDocument rald = IDHash.get(id);
			if (rald.getRequestId() == requestId) {
				result.add(rald);
			}
		}

		return result;	
	}

	public List<RequestAdminParticipantDocument> listByDocumentId(int documentId) {
		List<RequestAdminParticipantDocument> result = new ArrayList<RequestAdminParticipantDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestAdminParticipantDocument rald = IDHash.get(id);
			if (rald.getDocumentId() == documentId) {
				result.add(rald);
			}
		}

		return result;	
	}

	@Override
	public List<RequestAdminParticipantDocument> listByRequestIdAndGroupId(
			int requestId, int groupId) {
		initializeDocHash();


		List<RequestAdminParticipantDocument> result = new ArrayList<RequestAdminParticipantDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestAdminParticipantDocument rald = IDHash.get(id);
			if (rald.getRequestId() == requestId
					&& rald.getGroupId() == groupId) {
				result.add(rald);
			}
		}

		return result;	
	}

	private void initializeDocHash() {
		if (initialized == true) {
			return;
		}
		initialized = true;
	}

}
